# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from enum import Enum
from .sdmdltyperesourcereference import SDMDLTypeResourceReference
from ..sdapiobject import SDAPIObject
from ..sdapiobject import SDApiError
from ..apiexception import APIException

class TextureShape(Enum):
    """
    Enum representing the possible texture shapes
    """
    """Undefined"""
    Undefined = 0
    """Two-dimensional texture"""
    TwoDim = 1
    """Three-dimensional texture"""
    ThreeDim = 2
    """Cube map texture"""
    Cube = 3
    """Ptex texture"""
    Ptex = 4

class SDMDLTypeTextureReference(SDMDLTypeResourceReference):
    """
    Class used to store information about a MDL Texture Reference type
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDMDLTypeTextureReference
        """
        super(SDMDLTypeTextureReference, self).__init__(APIContext, handle, *args, **kwargs)

    def getTextureShape(self) -> TextureShape:
        """
        Get the texture shape

        """
        outTextureShape = ctypes.c_int()
        _res = self.mAPIContext.SDMDLTypeTextureReference_getTextureShape(self.mHandle, ctypes.byref(outTextureShape))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return TextureShape(outTextureShape.value)

